

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;



// vars

float3		foliage_pieceOffset;
float		foliage_pieceSize;
float		foliage_pieceDistance;
float2		foliage_distances;
float4		foliage_pieceColour;

////////////////////////////////////////////////////////////

struct VS_INPUT
{
	float4 position		: POSITION;
	float3 normal		: NORMAL;
	float4 colour		: COLOR;
	float2 uv1			: TEXCOORD0;
};


struct VS_OUTPUT
{
	float4	position	: POSITION;
	
	float	diffuse		: TEXCOORD0;
	float2	uv1			: TEXCOORD1;
	float	alpha		: TEXCOORD2;
};

////////////////////////////////////////////////////////////

VS_OUTPUT vs_foliage_full( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;

	float3 nNormal = normalize(input.position.xyz);
	output.diffuse = saturate(shader_light_ambient.r + saturate(dot( nNormal, -shader_light_direction )));

	output.position = mul(float4(input.position.xyz * foliage_pieceSize + foliage_pieceOffset,1), shader_transform_viewProj);

	output.uv1 = input.uv1;

	output.alpha = saturate((foliage_distances.x - foliage_pieceDistance) / (foliage_distances.x - foliage_distances.y));

	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_colour_1 = sampler_state
{
	Texture = (shader_texture_0);
	AddressU = Clamp; 
	AddressV = Clamp; 
};

////////////////////////////////////////////////////////////

float4 ps_foliage_full( VS_OUTPUT input ) : COLOR0
{
	return float4(tex2D(sampler_colour_1, input.uv1).rgb * foliage_pieceColour.rgb * foliage_pieceColour.a, tex2D(sampler_colour_1, input.uv1).a * input.alpha);

//	return float4(tex2D(sampler_colour_1, input.uv1).rgb * foliage_pieceColour.rgb * foliage_pieceColour.a * input.diffuse, tex2D(sampler_colour_1, input.uv1).a * input.alpha);
}

////////////////////////////////////////////////////////////

technique foliage_full_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_foliage_full();
		PixelShader = compile ps_2_0 ps_foliage_full();
	}
}

technique foliage_full_11_00
{
	pass P0
	{
	}
}